//
//  ActionBar.swift
//  SpeedKeys
//
//  Created by Jose Polo Ramos on 2/26/25.
//

import SwiftUI

let sidebarButtonWidth:CGFloat = 60

// The action button adds an entry to our shortcuts..
struct ActionBar:View {

    @Binding var data: Entries
    
    func addItem(){
        data.append(
            ["app": "app1" ,"shortcut":"short", "path": "path1", "command": ""]
        )
    }
    // needed for implementation.
    func setAccessFolders(){ }
    func save(){
        data.save()
    }
    func discardUnsavedChanges(){
        data.reset() 
    }
    
    var body: some View {
        HStack(spacing:10){
            //add
            Button(action: addItem) {
                Label("Add", systemImage: "plus.circle.fill")
            }
           
            Spacer()
            // access
            Button(action: setAccessFolders) {
                Label("Accessibility", systemImage: "lock.circle.fill")
            }
            Spacer()
            // save
            Button(action: save) {
                Label("Save", systemImage: "square.and.arrow.down.fill")
            }
            // reset
            Button(action: discardUnsavedChanges) {
                Label("Discard Changes", systemImage:
                        "arrow.uturn.backward.circle.fill")
            }
           
            
        }.padding(EdgeInsets.init(top: 12, leading: 12, bottom:12, trailing: 12))
            .background(Color.black)
    }
}

