//
//  ShortcutSheet.swift
//  SpeedKeys
//
//  Created by Jose Polo Ramos on 2/26/25.
//

import SwiftUI


// The shortcut sheet presented to the end-user when
// altering the shotcuts.
struct ShortcutSheet:View {
    
//    @Binding var data: Entries
    @Binding var showModal: Bool
    @Binding var shortCut:String
    @Binding var data: Entries
    @Binding var item:Entry
    @State   var pressedKey:String = ""
    
    
    var body: some View {

        VStack {
            Text("KeyBoard Shortcut")
            Divider()
            Text(pressedKey)
                .frame(minWidth: 200, minHeight: 25, alignment: .center)
                .border(Color.gray)
                .font(.system(size: 20, weight: .bold))
                .foregroundColor(.yellow)
                .cornerRadius(7)
                .padding()
                .focusable()
                .onKeyPress(action: { keyPress in
                    
                    var mods:[String] = []
                    
                    if keyPress.modifiers.contains(.command){
                        mods.append("⌘")
                    }
                    if keyPress.modifiers.contains(.option){
                        mods.append("⌥")
                    }
                    if keyPress.modifiers.contains(.shift){
                        mods.append("⇧")
                    }
                    if keyPress.modifiers.contains(.control){
                        mods.append("⌃")
                    }

                    mods.append(keyPress.characters)
                    pressedKey = mods.joined(separator: "+")
                    return .handled
                    
                })
            Divider()
            HStack{
                Button(action: {
                                showModal = false
                            }) {
                                Label("Dismiss", systemImage: "plus.circle.fill")
                            }
                Divider()
                Button(action: {
//                                data.put(value:pressedKey, asType : .shortcut, forKey : item.key )
                                item.shortCut = pressedKey
                                shortCut = pressedKey
                                showModal = false
                            }) {
                                Label("OK", systemImage: "plus.circle.fill")
                            }
            }.padding(20)
            
        }.padding(100)
    }
}
